Scriptname _MODaaaUCNPCPerfectBlockScript extends activemagiceffect

Int property Chance auto
{1-10 chance of actor deflecting attack. If Uselevel, the value will get increment by character level divided by ten.}

Sound property aaaUCPerfectBlockImpactSM auto
;ImpactDataSet property BlockSparksTest auto
Explosion property _MODSparksExplosion auto
Explosion property _MODSparksBlock auto
Explosion property _MODSparksBlockRing auto
Activator property _MODxMarkerActivatorDeleteSelf auto
ObjectReference BlockFX
Spell property StaggerSpell auto
Spell property _MODAbDeflectInvulnerabilitySpell auto

Bool property Uselevel auto
{DEFAULT = false}

Int ChanceStore
Actor SelfActor
bool DeflectOn

Event OnEffectStart(Actor akTarget, Actor akCaster)
	SelfActor = akTarget
	if(Uselevel == true)
		ChanceStore = SelfActor.Getlevel()/10 + Chance
	else
		ChanceStore = Chance
	endif
	RegisterForAnimationEvent(SelfActor, "SoundPlay.NPCHumanCombatShieldBlock")
	RegisterForAnimationEvent(SelfActor, "SoundPlay.NPCHumanCombatShieldRelease")
	RegisterForAnimationEvent(SelfActor, "SoundPlay.NPCHumanCombatShieldBash")
	if (Utility.Randomint(1,10) < ChanceStore)
		DeflectOn = true
	else
		DeflectOn = false
	endif
endEvent

Event OnAnimationEvent(ObjectReference akSource, string asEventName)
	if(asEventName == "SoundPlay.NPCHumanCombatShieldBlock" && DeflectOn == true)
		SelfActor.addspell(_MODAbDeflectInvulnerabilitySpell)
	elseif(asEventName == "SoundPlay.NPCHumanCombatShieldRelease" || asEventName == "SoundPlay.NPCHumanCombatShieldBash")
		SelfActor.removespell(_MODAbDeflectInvulnerabilitySpell)
	endif
EndEvent

Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
	if(abHitBlocked == true && akSource as weapon)
		;SelfActor.PlayImpactEffect(BlockSparksTest, "WEAPON", 0, 0, -1, 512, true, false)
		;Explosion proves to be the faster way to apply sparks.
		BlockFX = SelfActor.Placeatme(_MODxMarkerActivatorDeleteSelf)
		BlockFX.MoveToNode(SelfActor, "WEAPON")
		BlockFX.Placeatme(_MODSparksExplosion)
		if (DeflectOn == true)
			aaaUCPerfectBlockImpactSM.play(SelfActor as objectreference)
				if((akAggressor as actor).GetActorValue("Stamina") <= 100)
					BlockFX.Placeatme(_MODSparksBlock)
					BlockFX.Placeatme(_MODSparksBlockRing)
					StaggerSpell.Cast(akAggressor, none)
				else
					BlockFX.Placeatme(_MODSparksBlock)
					BlockFX.Placeatme(_MODSparksBlockRing)
				endif
			(akAggressor as actor).DamageActorValue("Stamina", SelfActor.GetActorValue("Block") * 2)
			SelfActor.RestoreActorValue("Stamina", game.GetGameSettingFloat("fStaminaBlockBase")*4)
		elseif (SelfActor.GetEquippedItemType(0) == 10)
			;Shield stagger.
			BlockFX.MoveToNode(SelfActor, "SHIELD")
			BlockFX.Placeatme(_MODSparksBlockRing)
			Debug.SendAnimationEvent(akAggressor, "recoilStart")
		endif
		;Fires every blocked hit, so it recalculate deflect chance.
		if (Utility.Randomint(1,10) < ChanceStore)
			DeflectOn = true
		else
			DeflectOn = false
		endIf
	endIf
EndEvent

Event OnEffectFinish(Actor akTarget, Actor akCaster)
	UnregisterForAnimationEvent(SelfActor, "SoundPlay.NPCHumanCombatShieldBlock")
	UnregisterForAnimationEvent(SelfActor, "SoundPlay.NPCHumanCombatShieldRelease")
	UnregisterForAnimationEvent(SelfActor, "SoundPlay.NPCHumanCombatShieldBash")
endEvent